<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';
require_once '../includes/functions.php';

// Check if user has permission
if (!hasPermission('manage_suppliers')) {
    echo json_encode(['error' => 'Permission denied']);
    exit;
}

header('Content-Type: application/json');

try {
    $prefix = $_GET['prefix'] ?? '';
    
    $stmt = $pdo->prepare("
        SELECT serial_numbers 
        FROM supplier_receipts 
        WHERE serial_numbers IS NOT NULL
    ");
    $stmt->execute();
    $max_number = 0;
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (!empty($row['serial_numbers'])) {
            $serials = json_decode($row['serial_numbers'], true);
            if (is_array($serials)) {
                foreach ($serials as $serial) {
                    // Remove prefix if it exists
                    $number = str_replace($prefix, '', $serial);
                    // Extract numeric part
                    if (preg_match('/\d+/', $number, $matches)) {
                        $num = intval($matches[0]);
                        $max_number = max($max_number, $num);
                    }
                }
            }
        }
    }
    
    echo json_encode(['success' => true, 'lastNumber' => $max_number]);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
} 